/**
 * @file
 * Activate the Assistant.
 */

(function (Drupal, once, $) {
  Drupal.behaviors.site_assistant = {
    attach: function attach(context, settings) {
      const elements = once('site_assistant.assistant', '.site-assistant', context);
      elements.forEach(function (siteAssistant) {
        var $siteAssistant = $(siteAssistant);
        var pageModels = [];

        const siteAssistantPages = once('site_assistant.assistant_page', '[data-assistant-page]', siteAssistant);
        siteAssistantPages.forEach(function (siteAssistantPage) {
          pageModels.push(new Drupal.site_assistant.AssistantPageModel({
            el: siteAssistantPage,
            id: siteAssistantPage.dataset.assistantPage
          }));
        });

        var model = new Drupal.site_assistant.AssistantModel({
          pages: $siteAssistant.find('[data-assistant-page]')
        });

        new Drupal.site_assistant.AssistantNavigationView({
          el: $siteAssistant.find('.assistant-navigation')[0],
          pageCollection: new Drupal.site_assistant.AssistantPageCollection(pageModels),
          model: model
        });
        new Drupal.site_assistant.AssistantView({
          el: siteAssistant,
          $window: $siteAssistant.find('.site-assistant__window'),
          window: $siteAssistant.find('.site-assistant__window')[0],
          pageCollection: new Drupal.site_assistant.AssistantPageCollection(pageModels),
          model: model
        });
      });
    }
  };

  Drupal.site_assistant = Drupal.site_assistant || {
    models: {},

    views: {}
  };
})(Drupal, once, jQuery);
