<?php

namespace Drupal\site_assistant;

use Drupal\Core\Config\Entity\ConfigEntityListBuilder;
use Drupal\Core\Url;
use Drupal\Core\Entity\EntityInterface;

/**
 * Defines a class to build a listing of assist list entry type entities.
 *
 * @see \Drupal\site_assistant\Entity\AssistantListEntryType
 */
class AssistantListEntryTypeListBuilder extends ConfigEntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    /** @var array{
     *   title: \Drupal\Core\StringTranslation\TranslatableMarkup,
     * } $header */
    $header = [];
    $header['title'] = $this->t('Name');
    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $entity) {
    /** @var array{
     *   title: array{
     *     data: string|\Drupal\Core\StringTranslation\TranslatableMarkup|null,
     *     class: array<string>,
     *   }
     * } $row */
    $row = [];
    $row['title'] = [
      'data' => $entity->label(),
      'class' => ['menu-label'],
    ];
    return $row + parent::buildRow($entity);
  }

  /**
   * {@inheritdoc}
   */
  public function getDefaultOperations(EntityInterface $entity) {
    $operations = parent::getDefaultOperations($entity);
    // Place the edit operation after the operations added by field_ui.module
    // which have the weights 15, 20, 25.
    if (isset($operations['edit'])) {
      $operations['edit']['weight'] = 30;
    }
    return $operations;
  }

  /**
   * {@inheritdoc}
   */
  public function render() {
    $build = parent::render();
    $build['table']['#empty'] = $this->t('No assist list entry types available. <a href=":link">Add assist list entry type</a>.', [
      ':link' => Url::fromRoute('entity.assistant_list_entry_type.add')->toString(),
    ]);
    return $build;
  }

}
