<?php

namespace Drupal\site_assistant\Traits;

/**
 * Provides a trait for accessing created time.
 */
trait EntityCreatedTrait {

  /**
   * Gets the timestamp of the entity creation.
   *
   * @return int
   *   The timestamp of the first entity save operation.
   */
  public function getCreatedTime(): int {
    return $this->get('created')->value;
  }

  /**
   * Sets the node creation timestamp.
   *
   * @param int $timestamp
   *   The node creation timestamp.
   *
   * @return $this
   *   The called node entity.
   */
  public function setCreatedTime(int $timestamp) {
    $this->set('created', $timestamp);
    return $this;
  }

}
