<?php

namespace Drupal\site_assistant\Traits;

use Drupal\site_assistant\AssistantInterface;
use Drupal\site_assistant\AssistantLibraryItemInterface;

/**
 * Trait to alter/provide general information in site_assistant forms.
 */
trait SiteAssistantFormGeneralTrait {

  /**
   * Adds a general element group to the form.
   *
   * @param \Drupal\site_assistant\AssistantInterface|\Drupal\site_assistant\AssistantLibraryItemInterface $entity
   *   Entity the form is build for.
   * @param array $form
   *   The form render array.
   */
  public function addFormElementGeneral(AssistantInterface|AssistantLibraryItemInterface $entity, array &$form): void {
    /** @var array{
     *   'title'?: array,
     *   ...
     * } $form */
    $form['general_information'] = [
      '#type' => 'fieldset',
      '#title' => $this->t('General information'),
      '#weight' => -101,
    ];

    if (isset($form['title'])) {
      // Move title field into new group.
      $form['title']['#group'] = 'general_information';
    }
  }

}
