<?php

namespace Drupal\site_assistant\Traits;

use Drupal\site_assistant\AssistantInterface;
use Drupal\site_assistant\AssistantLibraryItemInterface;

/**
 * Trait to alter/provide entity options in site_assistant forms.
 */
trait SiteAssistantFormOptionsTrait {

  /**
   * Adds an option element group to the form.
   *
   * @param \Drupal\site_assistant\AssistantInterface|\Drupal\site_assistant\AssistantLibraryItemInterface $entity
   *   Entity the form is build for.
   * @param array $form
   *   The form render array.
   */
  public function addFormElementOptions(AssistantInterface|AssistantLibraryItemInterface $entity, array &$form): void {
    /** @var array{
     *   'promote'?: array,
     *   'sticky'?: array,
     *   ...
     * } $form */
    $form['options'] = [
      '#type' => 'details',
      '#title' => $this->t('Promotion options'),
      '#group' => 'advanced',
      '#weight' => 95,
      '#optional' => TRUE,
    ];

    if (isset($form['promote'])) {
      $form['promote']['#group'] = 'options';
    }

    if (isset($form['sticky'])) {
      $form['sticky']['#group'] = 'options';
    }
  }

}
