<?php

namespace Drupal\Tests\site_assistant\ExistingSite\Assistant;

use Drupal\Core\Render\Element;
use Drupal\Tests\site_assistant\ExistingSite\ExistingSiteTestBase;
use Drupal\Tests\site_assistant\Traits\AssistantTrait;

/**
 * Tests the assistant form on an existing site.
 */
class FormTest extends ExistingSiteTestBase {

  use AssistantTrait;

  /**
   * The entity form builder.
   *
   * @var \Drupal\Core\Entity\EntityFormBuilder
   */
  protected $entityFormBuilder;

  /**
   * {@inheritdoc}
   */
  public function setUp(): void {
    parent::setUp();

    $this->loginWithPermissions('add assistant entity');

    $this->entityFormBuilder = $this->container->get('entity.form_builder');
  }

  /**
   * Test assistant entity form.
   */
  public function testFormElements(): void {
    $assistant = $this->createAssistantEmpty();
    $form = $this->entityFormBuilder->getForm($assistant);

    // Test title field.
    $widget_title = $form['title']['widget'];
    $this::assertTrue($widget_title['#required'], 'Field \'Title\' is not required.');

    // Test content field.
    $widget_content = $form['content']['widget'];
    $this::assertTrue($widget_content['#required'], 'Field \'Content\' is not required.');

    // Test visibility conditions field.
    $this::assertFalse($form['visibility']['#open'], 'Visibility conditions widget is expanded.');
    $widget_visibility = $form['visibility']['conditions'];
    $this::assertFalse($widget_visibility['#required'], 'Field \'Visibility conditions\' is required.');
    $conditions = Element::children($widget_visibility);
    $this::assertCount(0, $conditions, 'Visibility conditions has been added.');
  }

  /**
   * Test assistant entity form with loaded conditions.
   */
  public function testFormElementsWithConditions(): void {
    $assistant = $this->createAssistantEmpty();

    $configuration = [
      'roles' => [
        'anonymous' => FALSE,
        'authenticated' => 'authenticated',
        'administrator' => FALSE,
      ],
      'negate' => FALSE,
    ];
    $assistant->setVisibilityConfig('user_role', $configuration);

    $form = $this->entityFormBuilder->getForm($assistant);

    // Test visibility conditions field.
    $this::assertTrue($form['visibility']['#open'], 'Visibility conditions widget is collapsed.');
    $widget_visibility = $form['visibility']['conditions'];
    $conditions = Element::children($widget_visibility);
    $this::assertCount(1, $conditions, 'Visibility conditions are not set.');

    $this::assertArrayHasKey('user_role', $widget_visibility);
    $this::assertArrayHasKey('configuration', $widget_visibility['user_role']);
    $this::assertArrayHasKey('roles', $widget_visibility['user_role']['configuration']);

    // Assert "authenticated" role has been selected.
    $this::assertArrayHasKey('authenticated', $widget_visibility['user_role']['configuration']['roles']);
    $this::assertSame('authenticated', $widget_visibility['user_role']['configuration']['roles']['authenticated']['#default_value'], 'Role \'authenticated\' is not set.');

    // Assert "anonymous" role has not been selected.
    $this::assertArrayHasKey('anonymous', $widget_visibility['user_role']['configuration']['roles']);
    $this::assertNull($widget_visibility['user_role']['configuration']['roles']['anonymous']['#default_value'], 'Role \'anonymous\' is set.');
  }

}
