<?php

namespace Drupal\Tests\site_assistant\Traits;

use Drupal\site_assistant\Entity\Assistant;
use Drupal\site_assistant\AssistantInterface;

/**
 * A assistant entity helper trait for tests.
 */
trait AssistantTrait {

  /**
   * Create and return an assistant entity.
   *
   * @param array $values
   *   The entity values.
   *
   * @return \Drupal\site_assistant\AssistantInterface
   *   The assistant entity.
   */
  protected function createAssistant(array $values = []): AssistantInterface {
    /** @var \Drupal\site_assistant\AssistantInterface $assistant */
    $assistant = Assistant::create($values);
    $assistant->save();

    // Mark entity for cleanup after tests.
    $this->markEntityForCleanup($assistant);

    return $assistant;
  }

  /**
   * Create and return an empty assistant entity.
   *
   * @param bool $published
   *   (Optional) Whether to publish the assistant. Defaults to
   *   <code>TRUE</code>.
   *
   * @return \Drupal\site_assistant\AssistantInterface
   *   The assistant entity.
   */
  protected function createAssistantEmpty(bool $published = TRUE): AssistantInterface {
    /** @var \Drupal\site_assistant\AssistantInterface $assistant */
    $assistant = $this->createAssistant([
      'status' => $published,
    ]);

    return $assistant;
  }

}
