<?php

namespace Drupal\site_audit_checklist\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Database\Connection;
use Symfony\Component\DependencyInjection\ContainerInterface;

class SiteAuditChecklistController extends ControllerBase {

  protected $configFactory;
  protected $database;

  public function __construct(ConfigFactoryInterface $config_factory, Connection $database) {
    $this->configFactory = $config_factory;
    $this->database = $database;
  }

  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('config.factory'),
      $container->get('database')
    );
  }

  public function dashboard() {
    // Load task statuses from the database.
    $query = $this->database->select('site_audit_checklist_status', 's')
      ->fields('s');
    $tasks = $query->execute()->fetchAllAssoc('task_id');
  
    // Load task statuses from the database.
    $query = $this->database->select('site_audit_checklist_status', 's')
      ->fields('s');
    $tasks = $query->execute()->fetchAllAssoc('task_id');
  
    // The database query returns an array of objects, so access them as objects.
    $completed_tasks = array_filter($tasks, function ($task) {
        // Access the status property using object syntax.
        return (bool) $task->status;
    });
    
    $progress_percentage = count($tasks) > 0 ? (count($completed_tasks) / count($tasks)) * 100 : 0;
  
    return [
      '#theme' => 'site-audit-checklist-dashboard',
      '#tasks' => $tasks,
      '#progress' => round($progress_percentage),
      '#attached' => [
        'library' => [
          'site_audit_checklist/styles',
        ],
      ],
    ];
  }
}