# Site Audit Checklist

A simple, configurable checklist to help teams audit a Drupal site before launch.

## Features
- Track checklist items with status and notes
- Progress indicator on dashboard
- Update individual tasks inline
- Default checklist provided; overrideable via configuration

## Requirements
- Drupal core ^8.8 || ^9 || ^10

## Installation
1. Place the module in `web/modules/contrib/site_audit_checklist`.
2. Enable the module:
   - UI: Extend → search for "Site Audit Checklist" and enable.
   - Drush: `drush en site_audit_checklist -y`
3. Assign permissions (see below).

## Permissions
- **view site audit checklist**: View the dashboard.
- **administer site audit checklist**: Update task status and notes.

Configure via: People → Roles → Edit → Permissions.

## Routes and Navigation
- Dashboard: `/admin/config/development/site-audit` (`site_audit_checklist.dashboard`)
- Update task: `/admin/config/development/site-audit/update/{task_id}` (`site_audit_checklist.update_task`)
- Menu link: Configuration → Development → Site Audit Checklist

## Configuration
Default tasks are defined in `site_audit_checklist.checklist.yml`:
- Each task has: `id`, `title`, `description`, `url`.

To customize:
- Export config, edit/override via your config management, or provide an install-time override in your project configuration.

## Data Storage
The module creates table `site_audit_checklist_status` with fields:
- `id` (serial, primary key)
- `task_id` (varchar)
- `status` (tinyint: 0=pending, 1=completed)
- `notes` (text)
- `completed_by` (uid)
- `completed_timestamp` (int)

## Theming and Assets
- Dashboard theme hook: `site-audit-checklist-dashboard` (Twig: `templates/site-audit-checklist-dashboard.html.twig`)
- Library: `site_audit_checklist/styles` → loads `css/styles.css`

Override the template in your theme using standard Twig template suggestions.

## Usage
1. Visit the dashboard.
2. Click Update on a task to toggle completion and add notes.
3. Progress updates automatically based on completed tasks.

## Uninstallation
- Optional: remove task status records: `TRUNCATE site_audit_checklist_status;`
- Uninstall via UI or `drush pmu site_audit_checklist -y`.

## Troubleshooting
- 403 on dashboard: assign the appropriate permission(s).
- Route not found: clear caches `drush cr`.
- Styles not applied: ensure the library `site_audit_checklist/styles` is loaded (it is attached by the controller by default).

## Maintainers
Custom module in this project. Update responsibly and follow Drupal coding standards. 