<?php

/**
 * @file
 * Contains \Drupal\site_health\Form\MoProductsListForm.
 */

namespace Drupal\site_health\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Render\Markup;

class MoProductsListForm extends FormBase
{
    /**
     * {@inheritdoc}
     */
    public function getFormId()
    {
        return 'mo_products_list_form';
    }

    /**
     * Builds the form.
     */
    public function buildForm(array $form, FormStateInterface $form_state)
    {
        global $base_url;
        $module_path = $base_url . '/' . \Drupal::service('extension.list.module')->getPath("site_health");

        $related_products = [
            [
                'title' => 'SAML SP Provider',
                'description' => 'miniOrange provides Drupal SAML SP as a Single Sign-On solution that allows you to login to your Drupal site using SAML 2.0 compliant Identity Provider credentials. You can easily configure the Identity Provider with your Drupal site by simply providing a metadata URL or metadata file.',
                'image' => 'SAML-SP.webp',
                'link' => 'https://plugins.miniorange.com/drupal-saml-single-sign-on-sso',
            ],
            [
                'title' => 'OAuth Client',
                'description' => 'OAuth/OpenID Connect Client SSO (OAuth 2.0) module allows users residing at the OAuth Provider’s side to login to your Drupal site. The module syncs with all OAuth/OpenID providers that conform to OAuth 2.0 or OpenID Connect 1.0 standards.',
                'image' => 'Oauth-Client.webp',
                'link' => 'https://plugins.miniorange.com/drupal-sso-oauth-openid-single-sign-on'
            ],
            [
                'title' => 'Two Factor Authentication',
                'description' => 'Second-Factor Authentication (TFA) adds a second layer of security with an option to configure truly Passwordless Login. You can configure the module to send an OTP to your preferred mode of communication like phone/email, integrate with TOTP Apps like Google Authenticator or configure hardware token 2FA method.',
                'image' => 'Two-Factor.webp',
                'link' => 'https://plugins.miniorange.com/drupal-two-factor-authentication-2fa'
            ],
            [
                'title' => 'OTP Verification',
                'description' => 'Drupal OTP Verification module verifies Email Address/Mobile Number of users by sending verification code(OTP) during registration. It eliminates the possibility of a user registering with invalid personal details (phone number or email) on the Drupal site.',
                'image' => 'OTP-verify.webp',
                'link' => 'https://plugins.miniorange.com/drupal-otp-verification'
            ],
            [
                'title' => 'REST API Authentication',
                'description' => 'Drupal REST & JSON API Authentication module secures your Drupal site APIs against unauthorized access by enforcing different authentication methods including Basic Authentication, API Key Authentication, JWT Authentication, Third-Party Provider Authentication, etc.',
                'image' => 'REST-API.webp',
                'link' => 'https://plugins.miniorange.com/drupal-rest-api-authentication'
            ],
            [
                'title' => 'Session Management',
                'description' => 'User Session Management module helps you to manage the Drupal user session-related operations. It efficiently handles user sessions and provides you with multiple features like terminating any user session from the admin section, auto-logout user on being idle for the configured amount of time, limiting the number of simultaneous sessions per user, IP-based login restrictions, and many more.',
                'image' => 'Session-Management.webp',
                'link' => 'https://plugins.miniorange.com/drupal-session-management'
            ],
        ];

        $form['markup_library'] = array(
            '#attached' => array(
                'library' => array(
                    "site_health/site_health.admin"
                )
            )
        );

        // Related Products Section
        $form['related_products_section'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['section-container'],
            ],
        ];

        $form['related_products_section']['title'] = [
            '#type' => 'markup',
            '#markup' => '<h3>miniOrange Addon Products</h3>',
            '#prefix' => '<div class="section-title">',
        ];

        $form['related_products_section']['upgrade-button'] = [
            '#type' => 'link',
            '#title' => t('View All Products'),
            '#url' => \Drupal\Core\Url::fromUri('https://plugins.miniorange.com/drupal'),
            '#attributes' => [
                'class' => ['button', 'button--primary'],
            ],
            '#target' => '_blank',
            '#suffix' => '</div>',
        ];

        // Features Grid Container
        $form['related_products_section']['features_grid'] = [
            '#type' => 'container',
            '#attributes' => [
                'class' => ['features-grid']
            ],
        ];

        // Feature boxes with images

        foreach ($related_products as $index => $product) {
            $form['related_products_section']['features_grid']['feature_' . $index] = [
                '#type' => 'container',
                '#attributes' => [
                    'class' => ['feature-box']
                ],
            ];

            $form['related_products_section']['features_grid']['feature_' . $index]['title'] = [
                '#type' => 'markup',
                '#markup' => '<h5>' . $product['title'] . '</h5><hr>',
            ];

            // Image
            $form['related_products_section']['features_grid']['feature_' . $index]['image'] = [
                '#type' => 'markup',
                '#markup' => $this->t('<div><img class="feature-image" src=":module_path/includes/images/:image" alt=":title"></div>', [
                    ':module_path' => $module_path,
                    ':image' => $product['image'],
                    ':title' => $product['title'],
                ]),
            ];

            // Title and Description
            $form['related_products_section']['features_grid']['feature_' . $index]['content'] = [
                '#type' => 'markup',
                '#markup' => '<span class="product-description">' . $product['description'] . '</span>',
            ];

            // View Details Button
            $form['related_products_section']['features_grid']['feature_' . $index]['button'] = [
                '#type' => 'link',
                '#title' => t('View Details'),
                '#url' => \Drupal\Core\Url::fromUri($product['link']),
                '#attributes' => [
                    'class' => ['button', 'button--primary'],
                    'style' => 'margin-top: 10px;',
                ],
                '#target' => '_blank',
            ];
        }

        return $form;
    }

    /**
     * Submits the form.
     */
    public function submitForm(array &$form, FormStateInterface $form_state)
    {
        // No action needed on submit.
    }
}
