<?php

namespace Drupal\site_health\Plugin\QueueWorker;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Queue\QueueWorkerBase;
use Drupal\site_health\Service\QueryLoggerService;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Processes query logging queue items.
 *
 * @QueueWorker(
 *   id = "site_health_log",
 *   title = @Translation("Query Monitor Log Processor"),
 *   cron = {"time" = 30}
 * )
 */
class QueryLogProcessor extends QueueWorkerBase implements ContainerFactoryPluginInterface {

  /**
   * The query logger service.
   *
   * @var \Drupal\site_health\Service\QueryLoggerService
   */
  protected $queryLogger;

  /**
   * Constructs a QueryLogProcessor object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin_id for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\site_health\Service\QueryLoggerService $query_logger
   *   The query logger service.
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, QueryLoggerService $query_logger) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
    $this->queryLogger = $query_logger;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('site_health.query_logger')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function processItem($data) {
    $this->queryLogger->processBatchLogging($data);
  }

} 