# Site Health By miniOrange

A secure and performance-optimized Drupal module for monitoring database queries with advanced security features and configurable performance settings.

## ⚠️ IMPORTANT SECURITY NOTICE

This module has been significantly enhanced with security and performance improvements. **DO NOT use this module in production environments without careful consideration of the security and performance implications.**

## 🔒 Security Features

### Enhanced Security Measures
- **Query Sanitization**: Automatically removes sensitive data (passwords, tokens, API keys, etc.) from logged queries
- **Secure Hashing**: Uses SHA-256 instead of MD5 for query hashing
- **XSS Prevention**: Proper use of Drupal render arrays to prevent cross-site scripting
- **Granular Permissions**: Separate permissions for viewing, deleting, and exporting data
- **Information Disclosure Prevention**: Sanitized caller information and URI logging
- **Admin Path Exclusion**: Automatically excludes admin paths and sensitive endpoints

### Data Protection
- Sensitive data patterns are automatically detected and replaced with `[REDACTED]`
- Email addresses are replaced with `[EMAIL_REDACTED]`
- Credit card numbers are replaced with `[CARD_REDACTED]`
- Query length is limited to prevent storage abuse
- Automatic exclusion of high-risk tables (sessions, watchdog, etc.)

## ⚡ Performance Optimizations

### Asynchronous Processing
- **Queue-based Logging**: Uses Drupal's queue system for background processing
- **Batch Processing**: Logs are processed in batches to reduce database load
- **Rate Limiting**: Configurable rate limits to prevent excessive logging
- **Sampling**: Only logs a percentage of requests (configurable)

### Database Optimizations
- **Efficient Cleanup**: Batch deletion of old logs to prevent locking
- **Proper Indexing**: Optimized database indexes for better query performance
- **Schema Improvements**: Better field types and sizes for improved storage

### Memory Management
- **Peak Memory Tracking**: More accurate memory usage measurement
- **Optimized Exclusions**: Improved table exclusion logic using regex
- **Reduced Memory Footprint**: Better memory management in logging process

## 📋 Configuration Options

### Monitoring Settings
- **Enable/Disable Monitoring**: Turn monitoring on/off
- **Sampling Rate**: Percentage of requests to monitor (1-100%)
- **Rate Limiting**: Maximum requests per minute to log

### Security Settings
- **Query Sanitization**: Remove sensitive data from queries
- **Caller Information**: Control whether to log caller information
- **Maximum Query Length**: Limit query length for storage efficiency

### Performance Settings
- **Asynchronous Logging**: Enable background processing
- **Admin Path Exclusion**: Skip admin pages for better performance
- **Table Exclusions**: Exclude specific tables from monitoring

### Data Retention
- **Retention Period**: How long to keep logs (1-365 days)
- **Maximum Entries**: Maximum number of log entries to keep
- **Automatic Cleanup**: Background cleanup process

## 🛠️ Installation & Setup

1. **Install the module** in your Drupal site's `modules/custom/` directory
2. **Enable the module** through the Drupal admin interface
3. **Configure permissions** for appropriate user roles:
   - `administer site_health` - Full administrative access
   - `view query monitor reports` - View monitoring reports
   - `delete query monitor logs` - Delete query logs
   - `export query monitor data` - Export monitoring data

4. **Configure settings** at `/admin/config/development/site_health`

## 🔧 Recommended Configuration

### For Development Environments
```yaml
enable_monitoring: true
sampling_rate: 100
rate_limit_per_minute: 300
sanitize_queries: true
use_async_logging: true
exclude_admin_paths: false
log_retention_days: 7
max_log_entries: 50000
```

### For Staging Environments
```yaml
enable_monitoring: true
sampling_rate: 50
rate_limit_per_minute: 100
sanitize_queries: true
use_async_logging: true
exclude_admin_paths: true
log_retention_days: 3
max_log_entries: 10000
```

### For Production (NOT RECOMMENDED)
```yaml
enable_monitoring: false  # Keep disabled
sampling_rate: 1          # If absolutely necessary
rate_limit_per_minute: 10
sanitize_queries: true
use_async_logging: true
exclude_admin_paths: true
log_retention_days: 1
max_log_entries: 1000
```

## 📊 Usage

### Viewing Reports
1. Navigate to `/admin/reports/miniorange-query-monitor`
2. Use the tabs to view different types of reports:
   - **Overview**: General statistics
   - **Slow Queries**: Queries exceeding time thresholds
   - **Heavy Queries**: Queries with high memory usage
   - **Frequent Queries**: Most commonly executed queries

### Managing Data
- **Delete All Logs**: Use the delete button on the overview page (requires `delete query monitor logs` permission)
- **Automatic Cleanup**: Logs are automatically cleaned based on retention settings
- **Manual Cleanup**: Run `drush queue:run miniorange_query_monitor_cleanup`

## 🔄 Queue Processing

The module uses Drupal's queue system for background processing:

```bash
# Process logging queue
drush queue:run miniorange_query_monitor_log

# Process cleanup queue
drush queue:run miniorange_query_monitor_cleanup

# Run all queues
drush cron
```

## ⚠️ Warnings and Limitations

### Performance Impact
- **High Traffic Sites**: Can significantly impact performance
- **Database Growth**: Logs can grow very quickly
- **Memory Usage**: Monitoring adds memory overhead

### Security Considerations
- **Sensitive Data**: Despite sanitization, some sensitive data may still be logged
- **Information Disclosure**: Query patterns can reveal application structure
- **Access Control**: Ensure proper permissions are configured

### Operational Considerations
- **Disk Space**: Monitor disk usage carefully
- **Backup Impact**: Large log tables can impact backup performance
- **Database Maintenance**: Regular cleanup is essential

## 🚨 Troubleshooting

### Common Issues

1. **Performance Problems**
   - Reduce sampling rate
   - Enable admin path exclusion
   - Increase rate limiting
   - Ensure async logging is enabled

2. **Memory Issues**
   - Reduce max log entries
   - Decrease retention period
   - Add more table exclusions

3. **Queue Processing Problems**
   - Check cron configuration
   - Manually run queue workers
   - Check error logs

### Log Locations
- **Module Logs**: Admin > Reports > Recent log messages (filter by "miniorange_query_monitor")
- **PHP Errors**: Check PHP error logs
- **Database Logs**: Check database slow query logs

## 🔐 Security Best Practices

1. **Permissions**: Only grant necessary permissions to trusted users
2. **Environment**: Use only in development/staging environments
3. **Data Retention**: Keep retention periods as short as possible
4. **Regular Audits**: Regularly review logged data for sensitive information
5. **Access Monitoring**: Monitor who accesses query reports
6. **Secure Deletion**: Ensure logs are properly deleted when no longer needed

## 📈 Performance Monitoring

Monitor these metrics when using the module:
- Database query execution time
- Memory usage patterns
- Disk space consumption
- Queue processing performance
- Overall site performance impact

## 🔄 Updates and Maintenance

- **Regular Updates**: Keep the module updated for security patches
- **Configuration Review**: Regularly review and adjust configuration
- **Performance Testing**: Test performance impact before deploying
- **Security Audits**: Regularly audit logged data for sensitive information

## 🆘 Support and Contributing

For issues, feature requests, or contributions, please follow Drupal community guidelines for module development and security reporting.

## 📄 License

This module follows Drupal licensing terms. Please ensure compliance with your organization's security and privacy policies before use. 