# Configuration

The Site Key Mutator module is configured through container service parameters.

## Sample configuration file

```yml title='local.services.yml'
parameters:
  site_key_mutator.mutate_mode: "empty"
```

## Mutation mode
`site_key_mutator.mutate_mode` configures how the site key will be mutated.

/// html | div.config_mutation_mode

| Value | Purpose |
| ----- | ------- |
| `"empty"` | No site key will be sent with the request. This mode is recommended for the highest level of privacy. This is the default mode. |
| `"random"` | A new random key will be sent with each new request. |
| `"random-not-empty"` | Allows the calling code to selectively determine if a site id is sent. When a requester provides a site id it will be randomized, empty requests will be passed through without alternation. This mode is recommended for site owners that intends for their installs to be counted in usage statistics while not uniquely identifying their site. |

///

## Configuring a custom services.yml file

For more details on enabling a custom services.yml see `$settings['container_yamls']` in the sites `settings.php`
