<?php

namespace Drupal\site_settings_extended\Routing;

use Drupal\Core\Config\ConfigFactoryInterface;
use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\site_settings_extended\Controller\ConfigPagesSettingsController;
use Symfony\Component\Routing\RouteCollection;
use Drupal\site_settings_extended\Form\AllSiteSettingsForm;

class RouteSubscriber extends RouteSubscriberBase {

  /**
   * Constructs the route subscriber.
   *
   * @param \Drupal\Core\Config\ConfigFactoryInterface $configFactory
   */
  public function __construct(
    protected ConfigFactoryInterface $configFactory,
  ) {}

  /**
   * {@inheritDoc}
   */
  protected function alterRoutes(RouteCollection $collection) {
    if ($route = $collection->get('entity.site_setting_entity.collection')) {
      $config = $this->configFactory->get('site_settings_extended.settings');
      $form_mode = $config->get('form_mode');

      if ($form_mode !== 'default') {
        switch ($form_mode) {
          case 'single_form':
            // Alter collection route.
            $route->setDefaults([
              '_form' => AllSiteSettingsForm::class,
              '_title' => 'Settings',
            ]);
            break;

          case 'config_pages':
            // Alter collection route.
            $route->setDefaults([
              '_controller' => ConfigPagesSettingsController::class . '::overview',
              '_title' => 'Settings',
            ]);
            break;
        }

        $route->setPath('/admin/config/settings');
      }
    }
  }

}
