(function ($, Drupal, once) {
  'use strict';

  Drupal.behaviors.siteSettingsExtendedAdmin = {
    attach: function (context, settings) {
      let tabindex = 0;

      $(once('site_settings_extended.vertical_tabs', 'ul.vertical-tabs__menu li.vertical-tabs__menu-item')).each((i, tab) => {
        let item = $(tab);
        item.attr('tabindex', tabindex);
        tabindex++;


        item.on('click', () => {
          localStorage.setItem('site_settings_extended.active_tab', item.index());
        });
      });

      let verticalTabs = $('.vertical-tabs__panes');

      if (!window.location.hash) {
        // Check if we can use saved value from local storage.
        let active_tab = localStorage.getItem('site_settings_extended.active_tab');
        if (active_tab !== undefined) {
          let tabFocus = verticalTabs.find('> .vertical-tabs__pane').eq(active_tab);

          if (tabFocus.length) {
            tabFocus.data('verticalTab').focus();
          }
        }
      }
    }
  };
})(jQuery, Drupal, once);
