<?php

namespace Drupal\site_settings_extended\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Render\Markup;

class SiteSettingsExtendedConfigForm extends ConfigFormBase {

  /**
   * {@inheritDoc}
   */
  public function getFormId() {
    return 'site_settings_extended_config_form';
  }

  /**
   * {@inheritDoc}
   */
  public function getEditableConfigNames() {
    return ['site_settings_extended.settings'];
  }

  /**
   * {@inheritDoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('site_settings_extended.settings');

    $form['_warning'] = [
      '#type' => 'markup',
      '#markup' => Markup::create('<h3>Saving this form will flush all cache bins.</h3>'),
    ];

    $form['form_mode'] = [
      '#type' => 'radios',
      '#title' => $this->t('Form mode'),
      '#options' => [
        'default' => $this->t('Default (Site Settings)'),
        'single_form' => $this->t('All settings in a single form (vertical tabs)'),
        'config_pages' => $this->t('Config pages (renders like core configuration pages, one form/page per group)'),
      ],
      '#default_value' => $config->get('form_mode'),
      '#required' => TRUE,
      '#config_target' => 'site_settings_extended.settings:form_mode',
    ];

    $form['use_modals'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Use modals for add/edit forms'),
      '#description' => $this->t('Loads the add/edit forms in modals rather than full pages.'),
      '#default_value' => $config->get('use_modals'),
      '#config_target' => 'site_settings_extended.settings:use_modals',
    ];

    $form['remove_content_tab'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Remove content tab'),
      '#description' => $this->t('Removes the "Site Settings" tab on the Content overview.'),
      '#default_value' => $config->get('remove_content_tab'),
      '#config_target' => 'site_settings_extended.settings:remove_content_tab',
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritDoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    parent::submitForm($form, $form_state);
    // Flush all caches.
    drupal_flush_all_caches();
  }

}
