CONTENTS OF THIS FILE
---------------------

 * Introduction
 * Requirements
 * Installation
 * Configuration
 * Customisation
 * The Future

INTRODUCTION
------------

Current Maintainer: Gideon Cresswell (_DrupalGideon_)
<https://www.drupal.org/u/drupalgideon>

The **Site Status Message** is a simple module to display a site wide message to
your users at the top of each page. Use cases could be to inform of known
downtime in the future, to advertise a special offer on the site or some
important news that needs highlighting.

An optional link to a page with more information can be displayed after the
message.

It was completely inspired by the Drupal.org downtime message displayed October
2013 before the update of Drupal.org from Drupal 6 to Drupal 7.


REQUIREMENTS
------------

None.


INSTALLATION
------------

Install as usual, see
https://www.drupal.org/docs/extending-drupal/installing-modules for further
information.


CONFIGURATION
-------------

The module can be configured on the configuration page at 
`/admin/config/system/site-status-message`.
The message to be displayed can be up to 256 characters in length, and the page
with more information can be a node on the site. The message can be displayed on
either the public facing pages of the site, the Admin pages, or both.

If the message box is left blank, no message will be displayed.

You can quickly disable the message too without losing your previous message
with an enable message button.

CUSTOMISATION
-------------

The module ships with a template file that can be overridden in your own theme.

Copy the site-status-message.html.twig file into your theme directory to make
your own HTML changes.

Either the CSS ID `#site-status-message` or class `.site-status-message` can be
used in a custom CSS file to override the provided CSS.


THE FUTURE
----------

The Drupal 7 version has these extra features that will be ported to the Drupal
9/10 versions in due course.

 * Allow external URLs to be used for the Read More link
 * Schedule messages
 * Provide different colour backgrounds for different message statuses
 
These enhancements are on the roadmap.

 * Show messages on specific site pages
 * Alert dialog - ajax delivered messages
 * Show message in a block
