<?php

declare(strict_types=1);

namespace Drupal\RecipeKit\SiteTemplate\Command;

use Composer\Command\BaseCommand;
use Drupal\RecipeKit\SiteTemplate\Plugin;
use Symfony\Component\Console\Input\InputArgument;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Process\PhpExecutableFinder;
use Symfony\Component\Process\Process;

final class ContentExportCommand extends BaseCommand {

  /**
   * {@inheritdoc}
   */
  protected function configure(): void {
    $this->setName('site-template:export:content')
      ->setAliases(['st:excont'])
      ->setDescription('Exports a content entity into a site template, with its dependencies.')
      ->addArgument('template', InputArgument::REQUIRED, 'The name of the site template to modify.')
      ->addArgument('entity_type', InputArgument::REQUIRED, 'The type of entity to export (e.g., node, taxonomy_term).')
      ->addArgument('entity_id', InputArgument::REQUIRED, 'The ID of the entity to export.');
  }
  /**
   * {@inheritdoc}
   */
  protected function execute(InputInterface $input, OutputInterface $output): int {
    $dir = Plugin::getRecipeDirectory() . '/' . $input->getArgument('template') . '/content';

    $command = [
      (new PhpExecutableFinder())->find(),
      'core/scripts/drupal',
      'content:export',
      $input->getArgument('entity_type'),
      $input->getArgument('entity_id'),
      '--with-dependencies',
      "--dir=$dir",
    ];
    $process = new Process($command, Plugin::getDrupalRoot());
    $process->mustRun();

    $output->writeln("Exporting content to <comment>$dir</comment>");
    return 0;
  }

}
