<?php

declare(strict_types=1);

namespace Drupal\RecipeKit\SiteTemplate\Drush\Commands;

use Consolidation\AnnotatedCommand\CommandData;
use Consolidation\AnnotatedCommand\Hooks\HookManager;
use Drupal\Component\Serialization\Yaml;
use Drush\Attributes as CLI;
use Drush\Commands\config\ConfigExportCommands;
use Drush\Commands\DrushCommands;
use Symfony\Component\Finder\Finder;

final class SiteTemplateCommands extends DrushCommands {

  /**
   * Exports site configuration into a site template.
   */
  #[CLI\Hook(
    type: HookManager::POST_COMMAND_HOOK,
    target: ConfigExportCommands::EXPORT,
  )]
  public function exportConfiguration($result, CommandData $data): void {
    ['destination' => $destination] = $data->options();

    if ($destination && basename($destination) === 'config' && file_exists(dirname($destination) . '/recipe.yml')) {
      // The core.extension config should never be included in a recipe.
      @unlink($destination . DIRECTORY_SEPARATOR . 'core.extension.yml');

      $finder = Finder::create()
        ->in($destination)
        ->depth(0)
        ->files()
        ->name('*.yml');

      foreach ($finder as $file) {
        $data = Yaml::decode($file->getContents());
        unset($data['_core'], $data['uuid']);
        file_put_contents($file->getPathname(), Yaml::encode($data));
      }
      $this->io()->info('Deleted system-specific values from the exported configuration.');
    }
  }

}
