<?php

declare(strict_types=1);

namespace Drupal\RecipeKit\SiteTemplate\Drush\Generators;

use DrupalCodeGenerator\Asset\AssetCollection as Assets;
use DrupalCodeGenerator\Attribute\Generator;
use DrupalCodeGenerator\Command\BaseGenerator;

#[Generator(
  name: 'site-template',
  description: 'Generates a stub site template.',
  templatePath: __DIR__,
)]
final class SiteTemplateGenerator extends BaseGenerator {

  /**
   * {@inheritdoc}
   */
  protected function generate(array &$vars, Assets $assets): void {
    $ir = $this->createInterviewer($vars);

    $vars['machine_name'] = $ir->askMachineName();
    $vars['name'] = $ir->askName();

    $assets->addFile('{machine_name}/recipe.yml', 'recipe.yml.twig');
    $assets->addFile('{machine_name}/composer.json', 'composer.json.twig');
  }

}
