<?php

declare(strict_types=1);

namespace Drupal\RecipeKit\SiteTemplate;

use Composer\Composer;
use Composer\Plugin\Capability\CommandProvider as CommandProviderCapability;
use Drupal\RecipeKit\SiteTemplate\Command\AddExtensionCommand;
use Drupal\RecipeKit\SiteTemplate\Command\ContentExportCommand;

final class CommandProvider implements CommandProviderCapability {

  private readonly Composer $composer;

  public function __construct(array $arguments) {
    ['composer' => $this->composer] = $arguments;
  }

  /**
   * {@inheritdoc}
   */
  public function getCommands(): array {
    return [
      new AddExtensionCommand($this->composer),
      new ContentExportCommand(),
    ];
  }

}
