<?php

declare(strict_types=1);

namespace Drupal\RecipeKit\SiteTemplate;

use Composer\Composer;
use Composer\IO\IOInterface;
use Composer\Plugin\Capability\CommandProvider as CommandProviderCapability;
use Composer\Plugin\Capable;
use Composer\Plugin\PluginInterface;
use Composer\Util\Platform;
use Drupal\Core\Recipe\Recipe;

/**
 * Provides functionality that can be used by site templates.
 */
final class Plugin implements PluginInterface, Capable {

  private static string $recipeDir;

  public static function getDrupalRoot(): string {
    return dirname((new \ReflectionClass('Drupal'))->getFileName(), 3);
  }

  public static function getRecipeDirectory(): string {
    return self::$recipeDir;
  }

  /**
   * {@inheritdoc}
   */
  public function getCapabilities(): array {
    return [
      CommandProviderCapability::class => CommandProvider::class,
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function activate(Composer $composer, IOInterface $io): void {
    $extra = $composer->getPackage()->getExtra();

    foreach ($extra['installer-paths'] ?? [] as $path => $criteria) {
      // The first configured install path which matches the criteria is the
      // one we'll use, since that is what Composer would also do.
      if (in_array('type:' . Recipe::COMPOSER_PROJECT_TYPE, $criteria, TRUE)) {
        $path = Platform::getCwd() . DIRECTORY_SEPARATOR . $path;
        self::$recipeDir = str_replace('{$name}', '', $path);
        return;
      }
    }
    throw new \RuntimeException('Cannot determine where recipes are installed. Is one configured in `installer-paths`?');
  }

  /**
   * {@inheritdoc}
   */
  public function deactivate(Composer $composer, IOInterface $io): void {
    // Nothing to do here.
  }

  /**
   * {@inheritdoc}
   */
  public function uninstall(Composer $composer, IOInterface $io): void {
    // Nothing to do here.
  }

}
