<?php

namespace Drupal\siteimprove\Plugin;

use Drupal\Core\Plugin\DefaultPluginManager;
use Drupal\Core\Cache\CacheBackendInterface;
use Drupal\Core\Extension\ModuleHandlerInterface;

/**
 * Provides the Siteimprove.ai domain plugin manager.
 */
class SiteimproveDomainManager extends DefaultPluginManager {

  /**
   * Constructs a new SiteimproveDomainManager object.
   *
   * @param \Traversable $namespaces
   *   An object that implements \Traversable which contains the root paths
   *   keyed by the corresponding namespace to look for plugin implementations.
   * @param \Drupal\Core\Cache\CacheBackendInterface $cache_backend
   *   Cache backend instance to use.
   * @param \Drupal\Core\Extension\ModuleHandlerInterface $module_handler
   *   The module handler to invoke the alter hook with.
   */
  public function __construct(\Traversable $namespaces, CacheBackendInterface $cache_backend, ModuleHandlerInterface $module_handler) {
    parent::__construct('Plugin/SiteimproveDomain', $namespaces, $module_handler, 'Drupal\siteimprove\Plugin\SiteimproveDomainInterface', 'Drupal\siteimprove\Annotation\SiteimproveDomain');

    $this->alterInfo('siteimprove_siteimprove_domain_info');
    $this->setCacheBackend($cache_backend, 'siteimprove_siteimprove_domain_plugins');
  }

}
