Siteimprove Accessibility Module
================================

A Drupal module that integrates Siteimprove's Alfa accessibility engine 
to provide comprehensive accessibility scanning and reporting.

Features
--------

-   **Automated Accessibility Scanning**

-   **Compliance Dashboard**

-   **Issue Reporting & Tracking**

-   **Manual Scan Capabilities**

-   **Daily Statistics Aggregation**

-   **WCAG 2.1 AA Conformance Checking**

Requirements
------------

-   Drupal 10 or 11

-   PHP 8.1+

-   Node.js 16+ (for frontend development)

-   Drupal Core Modules:

    -   RESTful Web Services

    -   Language

    -   Taxonomy

Installation
------------

1. Install the module: drush pm:enable siteimprove_accessibility

2. Configure permissions for appropriate roles.

Configuration
-------------

Configure the module at:\
`/admin/config/siteimprove_accessibility/settings`

### Available Settings:

| Setting | Description | Default |
| --- | --- | --- |
| Enable Manual Scans | Shows manual scan button on nodes | Enabled |
| Auto-scan on Preview | Automatically scans during node preview | Enabled |
| Usage Analytics | Enable Pendo tracking | Disabled |

Usage
-----

### Scanning Content

1.  **Manual Scan**:

    -   Navigate to any content page

    -   Click the accessibility scan button

    -   View results in the expanded panel

2.  **Auto-Scan**:

    -   Enabled in module configuration

    -   Automatically runs during node preview

### Viewing Reports

1.  **Compliance Dashboard**:\
    `/admin/reports/siteimprove_accessibility/compliance-dashboard`

2.  **Issue Reporting**:\
    `/admin/reports/siteimprove_accessibility/issue-reporting`

API Endpoints
-------------

The module provides these REST endpoints:

| Endpoint | Method | Description |
| --- | --- | --- |
| `/siteimprove-accessibility/save-scan` | POST | Save scan results |
| `/siteimprove-accessibility/alfa-scan/node/{nid}` | GET | Get scans by node |
| `/siteimprove-accessibility/daily-stats` | GET | Get aggregated stats |
| `/siteimprove-accessibility/issues` | GET | List all issues |
| `/siteimprove-accessibility/pages-with-issues` | GET | List affected pages |

Permissions
-----------

| Permission | Description |
| --- | --- |
| `administer siteimprove_accessibility configuration` | Access settings form |
| `run siteimprove_accessibility scan` | Initiate scans |
| `delete siteimprove_accessibility scan` | Remove scan records |

Support
-------

For issues or feature requests, please:

1.  Check the documentation

2.  Open an issue in our issue queue

3.  Contact Siteimprove Support

License
-------

GPL-2.0-or-later

* * * * *

**Note**: This module requires a valid Siteimprove account for 
full functionality. 
Contact your Siteimprove representative for integration details.
