/**
 * @file
 * Siteimprove Alfa behaviors for scan.
 */

import { Audit } from '@siteimprove/alfa-act'
import rules from '@siteimprove/alfa-rules'
import { Rules as AlfaRuleFilter } from '@siteimprove/alfa-test-utils'
import { JQuery } from '@siteimprove/alfa-jquery'
import * as json from '@siteimprove/alfa-json'
import {
  getRuleMeta
} from '@siteimprove/accessibility-cms-components/src/helpers/transformAuditResults'
import {
  renderSinglePageReporting,
} from '@siteimprove/accessibility-cms-components'

(function (Drupal) {

  'use strict'

  Drupal.alfaActions = Drupal.alfaActions || {}

  Drupal.alfaActions.alfaAudit = Audit
  Drupal.alfaActions.alfaJson = json
  Drupal.alfaActions.alfaJQuery = JQuery
  Drupal.alfaActions.alfaRules = rules
  Drupal.alfaActions.alfaRuleFilter = AlfaRuleFilter
  Drupal.alfaActions.getRuleMeta = getRuleMeta

  Drupal.alfaActions.alfaRendererSPRI = function (data, elementId = 'single-page-reporting') {
    return renderSinglePageReporting(data, elementId)
  }

}(Drupal))
