/**
 * @file
 * Siteimprove Alfa behaviors for display.
 */

import {
  renderSinglePageReporting,
  renderComplianceDashboard,
  renderScanIssueReporting
} from '@siteimprove/accessibility-cms-components'

(function (Drupal) {

  'use strict'

  Drupal.alfaActions = Drupal.alfaActions || {}

  Drupal.alfaActions.alfaRendererSPRI = function (data, elementId = 'single-page-reporting') {
    return renderSinglePageReporting(data, elementId)
  }
  Drupal.alfaActions.alfaRendererCD = function (data, elementId = 'compliance-dashboard') {
    return renderComplianceDashboard(data, elementId)
  }
  Drupal.alfaActions.alfaRendererIssueReporting = function (data, callback, elementId = 'siteimprove-scan-report') {
    return renderScanIssueReporting(data, callback, elementId)
  }

}(Drupal))
