<?php

declare(strict_types=1);

namespace Drupal\siteimprove_accessibility\Controller;

use Drupal\Core\Controller\ControllerBase;
use Drupal\Core\Extension\ExtensionPathResolver;
use Drupal\siteimprove_accessibility\Entity\AlfaScan;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Returns responses for Siteimprove Accessibility routes.
 */
final class SiteimproveAccessibilityReportingController extends ControllerBase {

  /**
   * PathResolver service.
   *
   * @var \Drupal\Core\Extension\ExtensionPathResolver
   */
  protected ExtensionPathResolver $extensionPathResolver;

  /**
   * The controller constructor.
   */
  public function __construct(ExtensionPathResolver $extensionPathResolver) {
    $this->extensionPathResolver = $extensionPathResolver;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container): self {
    return new static(
      $container->get('extension.path.resolver')
    );
  }

  /**
   * Builds the response.
   */
  public function __invoke(): array {

    $build['content'] = [
      '#type' => 'item',
      '#markup' => $this->t('It works!'),
    ];

    return $build;
  }

  /**
   * Builds response for reporting menu items.
   *
   * @param string $viz_type
   *   The current viz type to be displayed.
   *
   * @return array
   *   Returns render array for controller.
   */
  public function content(string $viz_type): array {
    $build['content'] = [
      '#type' => 'markup',
      '#theme' => 'alfa_scan_data_display',
      '#viz_type' => $viz_type,
      '#initial_scan_run' => AlfaScan::isInitialRun(),
      '#module_path' => $this->extensionPathResolver->getPath('module', 'siteimprove_accessibility'),
    ];
    return $build;
  }

}
