<?php

declare(strict_types=1);

namespace Drupal\siteimprove_accessibility\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\siteimprove_accessibility\DailyStatsInterface;

/**
 * Defines the daily stats entity class.
 *
 * @ContentEntityType(
 *   id = "si_daily_stats",
 *   label = @Translation("Daily Stats"),
 *   label_collection = @Translation("Daily Stats"),
 *   label_singular = @Translation("daily stats"),
 *   label_plural = @Translation("daily stats"),
 *   label_count = @PluralTranslation(
 *     singular = "@count daily stats",
 *     plural = "@count daily stats",
 *   ),
 *   handlers = {
 *     "views_data" = "Drupal\views\EntityViewsData",
 *     "form" = {
 *       "delete" = "Drupal\Core\Entity\ContentEntityDeleteForm",
 *       "delete-multiple-confirm" =
 *   "Drupal\Core\Entity\Form\DeleteMultipleForm",
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     },
 *   },
 *   base_table = "siteimprove_accessibility_daily_stats",
 *   admin_permission = "administer siteimprove_accessibility",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "id",
 *     "uuid" = "uuid",
 *   },
 *   links = {
 *     "delete-form" = "/si-daily-stats/{si_daily_stats}/delete",
 *     "delete-multiple-form" = "/admin/content/daily-stats/delete-multiple",
 *   },
 * )
 */
final class DailyStats extends ContentEntityBase implements DailyStatsInterface {

  /**
   * Defines the base fields for the entity.
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type): array {
    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['created'] = BaseFieldDefinition::create('created')
      ->setLabel(t('Created'))
      ->setDescription(t('The time that the Daily Stats entry was created.'))
      ->setRequired(TRUE);

    $fields['aggregated_stats'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Aggregated Stats'))
      ->setDescription(t('JSON formatted aggregated statistics (max 256 characters).'))
      ->setSettings([
        'max_length' => 256,
      ]);

    return $fields;
  }

}
