<?php

declare(strict_types=1);

namespace Drupal\siteimprove_accessibility\Entity;

use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;
use Drupal\siteimprove_accessibility\OccurrenceInterface;

/**
 * Defines Occurrence entity.
 *
 * @ContentEntityType(
 *   id = "si_occurrence",
 *   label = @Translation("Occurrence"),
 *   handlers = {
 *     "form" = {
 *       "delete" = "Drupal\Core\Entity\ContentEntityDeleteForm",
 *       "delete-multiple-confirm" =
 *   "Drupal\Core\Entity\Form\DeleteMultipleForm",
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     },
 *   },
 *   links = {
 *     "delete-form" = "/si-occurrence/{si_occurrence}/delete",
 *     "delete-multiple-form" = "/admin/content/si-occurrence/delete-multiple",
 *   },
 *   base_table = "siteimprove_accessibility_occurrence",
 *   admin_permission = "administer siteimprove_accessibility",
 *   entity_keys = {
 *     "id" = "id",
 *     "uuid" = "uuid",
 *   },
 *   translatable = FALSE,
 * )
 */
final class Occurrence extends ContentEntityBase implements OccurrenceInterface {

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type): array {
    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['scan_id'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Scan ID'))
      ->setDescription(t('Reference to the AlfaScan entity.'))
      ->setSetting('target_type', 'alfa_scan')
      ->setRequired(TRUE);

    $fields['rule_id'] = BaseFieldDefinition::create('entity_reference')
      ->setLabel(t('Rule ID'))
      ->setDescription(t('Reference to a taxonomy term in Siteimprove Accessibility Rules vocabulary.'))
      ->setSetting('target_type', 'taxonomy_term')
      ->setSetting('handler_settings', [
        'target_bundles' => ['siteimprove_accessibility_rules'],
      ])
      ->setRequired(TRUE);

    $fields['occurrence'] = BaseFieldDefinition::create('integer')
      ->setLabel(t('Occurrence Count'))
      ->setDescription(t('The number of times the issue occurs in the scan.'))
      ->setRequired(TRUE)
      ->setDefaultValue(0);

    return $fields;
  }

}
