<?php

namespace Drupal\siteimprove_accessibility\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Ensures taxonomy term names are unique within a specific vocabulary.
 *
 * @Constraint(
 *   id = "UniqueTermName",
 *   label = @Translation("Unique term name", context = "Validation")
 * )
 */
class UniqueTermNameConstraint extends Constraint {

  /**
   * The error message shown when a duplicate term name is detected.
   *
   * @var string
   */
  public string $message = 'A term named "%name" already exists in this vocabulary.';

}
