import path from 'path'
import { fileURLToPath } from 'url'
import TerserPlugin from 'terser-webpack-plugin'

const __filename = fileURLToPath(import.meta.url)
const __dirname = path.dirname(__filename)

export default {
  entry: {
    'siteimprove-accessibility-alfa-scan-button': './assets/src/js/siteimprove-accessibility-alfa-scan-button.js',
    'siteimprove-accessibility-alfa-scan-display': './assets/src/js/siteimprove-accessibility-alfa-scan-display.js',
  },
  output: {
    path: path.resolve(__dirname, 'assets/dist/js'),
    filename: '[name].min.js',
  },
  module: {
    rules: [
      {
        test: /\.(js|jsx)$/,
        exclude: /node_modules\/(?!@siteimprove\/accessibility-cms-components)/,
        use: {
          loader: 'babel-loader',
          options: {
            presets: ['@babel/preset-env', '@babel/preset-react'],
          },
        },
      },
      {
        test: /\.css$/,
        use: ['style-loader', 'css-loader'],
      },
      {
        test: /\.(woff|woff2|eot|ttf|otf)$/i,
        type: 'asset/resource',
        generator: {
          filename: '../fonts/[name][ext][query]',
        },
      },
    ],
  },
  optimization: {
    minimize: true,
    minimizer: [
      new TerserPlugin({
        terserOptions: {
          compress: {
            drop_console: true, // Remove console.log statements
          },
          output: {
            comments: false, // Remove comments
          },
        },
      }),
    ],
  },
  devServer: {
    static: [
      path.resolve(__dirname, 'public'),
      path.resolve(
        __dirname,
        'node_modules/@siteimprove/accessibility-cms-components/public',
      ),
    ],
    port: 3311,
    hot: true,
    historyApiFallback: true,
  },
  resolve: {
    extensions: ['.js', '.jsx'],
  },
  mode: 'production',
}
