<?php

declare(strict_types=1);

namespace Drupal\sites_content_overrides\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Sites content overrides settings.
 */
final class SettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId(): string {
    return 'sites_group_overrides_settings';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames(): array {
    return ['sites_content_overrides.settings'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state): array {
    // @todo Use config_target API.
    $form['hide_source_field_on_override'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Hide source field on override'),
      '#default_value' => $this->config('sites_content_overrides.settings')->get('hide_source_field_on_override') ?? TRUE,
    ];
    $form['disable_source_field_on_override'] = [
      '#type' => 'checkbox',
      '#title' => $this->t('Disable source field on override'),
      '#default_value' => $this->config('sites_content_overrides.settings')->get('disable_source_field_on_override') ?? FALSE,
      '#states' => [
        'visible' => [
          ':input[name=hide_source_field_on_override]' => ['checked' => FALSE],
        ],
      ],
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state): void {
    $this->config('sites_content_overrides.settings')
      ->set('disable_source_field_on_override', boolval($form_state->getValue('disable_source_field_on_override')))
      ->set('hide_source_field_on_override', boolval($form_state->getValue('hide_source_field_on_override')))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
