<?php

namespace Drupal\sites_content_overrides\ParamConverter;

use Symfony\Component\Routing\Route;
use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\ParamConverter\ParamConverterInterface;

class EntityConverter implements ParamConverterInterface {

  public function __construct(protected ParamConverterInterface $inner) {}

  public function applies($definition, $name, Route $route) {
    return $this->inner->applies($definition, $name, $route);
  }

  public function convert($value, $definition, $name, array $defaults) {
    $entity = $this->inner->convert($value, $definition, $name, $defaults);

    if (!$entity) {
      return $entity;
    }

    $supported_entity_type_ids = sites_supported_entity_type_ids();
    if (!in_array($entity->getEntityTypeId(), $supported_entity_type_ids, true)) {
      return $entity;
    }


    // @todo Build param converter for sites.
    // This makes it work when viewing the cannonical route of an entity.
    if (isset($defaults['site']) && $site_id = $defaults['site']) {
      $site = \Drupal::service('plugin.manager.site')->getSite($site_id);
      return \Drupal::service('sites_content_overrides.site_aware_entity_resolver')->loadEffective($entity, $site);
    }

    return \Drupal::service('sites_content_overrides.site_aware_entity_resolver')->loadEffective($entity);
  }

}
