<?php

declare(strict_types=1);

namespace Drupal\sites_content_overrides\Plugin\SiteSetting;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\sites\Attribute\SiteSetting;
use Drupal\sites\Plugin\SiteSetting\SiteSettingPluginBase;

/**
 * Plugin implementation of the 'content_overrides'.
 */
#[SiteSetting(
  id: 'content_overrides',
  label: new TranslatableMarkup('Content override settings'),
  description: new TranslatableMarkup('Configure override settings on a per field basis.'),
  weight: 10,
)]
final class ContentOverrides extends SiteSettingPluginBase {

  use StringTranslationTrait;

  /**
   * {@inheritdoc}
   */
  public function defineSettings(): array {
    $settings = [];

    $supported_entity_type_ids = sites_supported_entity_type_ids();
    foreach ($supported_entity_type_ids as $entity_type_id => $entity_type) {
      $settings['content_overrides_field_names__' . $entity_type_id] = [
        'default' => '',
        'environment' => FALSE,
      ];
    }

    return $settings;
  }

  /**
   * {@inheritdoc}
   */
  public function buildSettingsForm(array $form, FormStateInterface $form_state): array {
    $supported_entity_type_ids = sites_supported_entity_type_ids();
    foreach ($supported_entity_type_ids as $entity_type_id) {
      $form['content_overrides_field_names__' . $entity_type_id] = [
        '#type' => 'textfield',
        // @todo load label
        '#title' => $this->t('@entity_type_label Field names', ['@entity_type_label' => $entity_type_id]),
        '#description' => $this->t('Comma separated list of field names.'),
        '#default_value' => $this->getSetting('content_overrides_field_names__' . $entity_type_id),
        '#maxlength' => 1024,
      ];
    }

    return $form;
  }

}
