<?php

declare(strict_types=1);

namespace Drupal\sites_content_overrides\Plugin\Validation\Constraint;

use Drupal\Core\Entity\Plugin\Validation\Constraint\EntityChangedConstraint;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\Core\Validation\Attribute\Constraint;

/**
 * Validation constraint for entity changed timestamp with site awareness.
 *
 * This constraint extends the core EntityChangedConstraint to support
 * site-specific revisions. It only compares changed timestamps within
 * the same site context, allowing concurrent editing across different sites.
 */
#[Constraint(
  id: 'SiteAwareEntityChanged',
  label: new TranslatableMarkup('Site-aware entity changed', [], ['context' => 'Validation']),
  type: ['entity']
)]
class SiteAwareEntityChangedConstraint extends EntityChangedConstraint {

}
