<?php

namespace Drupal\sites_content_overrides\Plugin\views\query_extend;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\sites_content_overrides\SiteAwareEntityResolverInterface;
use Drupal\views_query\Attribute\ViewsQueryExtend;
use Drupal\views_query\ViewsQueryPluginBase;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * View query plugin implementation for "sites_content_override".
 */
#[ViewsQueryExtend(
  id: 'sites_content_override',
)]
class SitesContentOverrideEntities extends ViewsQueryPluginBase {

  /**
   * Constructs a ViewsQueryPluginBase object.
   *
   * @param array $configuration
   *   A configuration array containing information about the plugin instance.
   * @param string $plugin_id
   *   The plugin ID for the plugin instance.
   * @param mixed $plugin_definition
   *   The plugin implementation definition.
   * @param \Drupal\Core\Entity\EntityTypeManagerInterface $entity_type_manager
   *   The entity type manager.
   * @param \Drupal\sites_content_overrides\SiteAwareEntityResolverInterface $siteAwareEntityResolver
   *   The site aware entity resolver.
   */
  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    EntityTypeManagerInterface $entity_type_manager,
    protected readonly SiteAwareEntityResolverInterface $siteAwareEntityResolver,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition, $entity_type_manager);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_type.manager'),
      $container->get('sites_content_overrides.site_aware_entity_resolver'),
    );
  }

  /**
   * {@inheritdoc}
   *
   * @todo Check if we can alter the views to determine the right vid instead?
   */
  public function assignEntitiesToResultAlter($ids, array $entities, array &$results): void {
    foreach ($results as &$result) {
      if ($result->_entity) {
        // Load the site-specific entity revision if exists.
        $result->_entity = $this->siteAwareEntityResolver->loadEffective($result->_entity);
      }
    }
  }

}
