<?php

declare(strict_types=1);

namespace Drupal\sites_migrator\Plugin\migrate\source;

use Drupal\Core\Entity\EntityFieldManagerInterface;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\State\StateInterface;
use Drupal\migrate_drupal_d8\Plugin\migrate\source\d8\ContentEntity;
use Drupal\migrate\Plugin\MigrationInterface;
use Drupal\Core\Site\Settings;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides a dynamic source path. Handy for migrating multiple sites. Settings example:
 *
 * $settings['migrate_source_path'] = 'sites/default/migration';
 *
 * @MigrateSource(
 *   id = "dynamic_file_path_entity",
 *   source_provider = "migrate_drupal_d8"
 * )
 */
class DynamicFilePathEntity extends ContentEntity {

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, MigrationInterface $migration, StateInterface $state, EntityTypeManagerInterface $entity_type_manager, EntityFieldManagerInterface $entity_field_manager, Settings $settings) {
    $setting_migrate_source_path = $settings::get('migrate_source_path');
    if (!$setting_migrate_source_path) {
      throw new \RuntimeException('Setting variable "migrate_source_path" is not set.');
    }
    $configuration['constants']['source_base_path'] = $setting_migrate_source_path;

    parent::__construct($configuration, $plugin_id, $plugin_definition, $migration, $state, $entity_type_manager, $entity_field_manager);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition, ?MigrationInterface $migration = NULL) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $migration,
      $container->get('state'),
      $container->get('entity_type.manager'),
      $container->get('entity_field.manager'),
      $container->get('settings'),
    );
  }

}
