<?php

declare(strict_types=1);

namespace Drupal\sites_migrator\Plugin\migrate\source;

use Drupal\migrate_drupal_d8\Plugin\migrate\source\d8\ContentEntity;
use Drupal\migrate\Row;

/**
 * Prepares user data via source plugin. E.g. if the name row is empty, then
 * the user entity won't be created.
 *
 * Example usage in your YAML file:
 *
 * ```
 * source:
 *   plugin: prepare_user
 *   entity_type: user
 * ```
 *
 * @MigrateSource(
 *   id = "prepare_user"
 * )
 */
class PrepareUser extends ContentEntity {

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row) {
    // Skip the row if the 'name' field is empty or NULL.
    if (empty($row->getSourceProperty('name'))) {
      return FALSE;
    }
    return parent::prepareRow($row);
  }
}
