<?php

declare(strict_types=1);

namespace Drupal\sites_migrator\Menu;

use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * Interface for MenuContentMigrator.
 */
interface MenuContentMigratorInterface {

  /**
   * Migrates menu items.
   *
   * @param string $sourceMenuName
   *   The name of the source menu.
   * @param int $groupId
   *   The ID of the group.
   * @param string $menuBundle
   *   The bundle of the menu.
   * @param string $menuLabel
   *   The label of the menu.
   * @param \Symfony\Component\Console\Output\ConsoleOutput|null $output
   *   Optional console output for progress bar.
   *
   * @return array
   *   List of created menu link plugin IDs.
   */
  public function migrateMenuItems(
    string $sourceMenuName,
    int $groupId,
    string $menuBundle,
    string $menuLabel,
    ?ConsoleOutput $output = NULL,
  ): void;

}
