# Sites Migrate

* Makes a normal site into a multi-site via the [Sites module](https://www.drupal.org/project/sites) suite
* Migrates content from other Drupal multi-site ecosystems (e.g. Domain module).

# Requirements
The following modules must be installed:
* [Sites](https://git.erdfisch.de/contrib/sites)
* [Sites Group](https://git.erdfisch.de/contrib/sites_group)

_Note:_ Currently these Drupal modules are located in an internal GitLab. These modules will be perspectively
moved to Drupal.org. The corresponding "placeholder" project is located here: https://www.drupal.org/project/sites

This module is also based on the [Drush](https://www.drush.org/) command line tool. Please make sure, that it's setup.

## Domain module
1. Make sure you've configured your sites.
2. Check that domains hostname config matches your hostname in `field_hostname` of your group type
3. Run our Drush command to assign the domain related content to sites: `drush sites-group:content-inherit-domain-module`

## Migrating menu content items
Let's say the machine name of the menu, which should be migrated is `main`. Like the default `Main navigation` menu. Your
group id is `3` and the group content menu id is `2`. Then you can migrate the menu via the following
[Drush](https://www.drush.org/) command:
```
drush sm:migrate-menu main 3 2
```
You'll see the following success message:
```
[OK] Successfully migrated 2 menu items from "main" into Group "3" and Group Menu "2".
```

### Migrating menu content bundles

#### Manage menu types
/admin/structure/group_content_menu_types

For fieldable menus in groups we do install the following Drupal modules:
* [Menu item extras](https://www.drupal.org/project/menu_item_extras)
* [Group content menu](https://www.drupal.org/project/group_content_menu)
* [Group content menu bundles](https://www.drupal.org/project/group_content_menu_bundles)

After these modules are installed, their fields can be managed at the following path:
`/admin/structure/group-content-menu-item-extras`.

#### Enabling a menu for your group type
To enable group menu content for your group type, you must edit the group type. E.g. your group
type is called `site`, then the corresponding admin config page is located here: `/admin/group/types/manage/site/content`

#### Adding a menu to your group type
Given your group id is `1`, you can do this here: `/group/1/menus`

_Note:_ The [Group content menu bundles](https://www.drupal.org/project/group_content_menu_bundles) module must
be installed, before any group content menus have been setup. Otherwise it's not installable.

#### Testing menu content bundles
For testing purposes, it's recommended to install the Menu Item Extras Demo Base module. This
is a submodule of the [Menu item extras](https://www.drupal.org/project/menu_item_extras) module.
It creates a demo menu with various fields in it.
