<?php

declare(strict_types=1);

namespace Drupal\sites_migrator\Commands;

use Drupal\sites_migrator\ContentInheritService;
use Drush\Commands\DrushCommands;

/**
 * A Drush command class for content inheritance to sites. Especially for
 * existing Drupal sites, which receive a new sites group module setup.
 */
final class ContentInheritCommands extends DrushCommands {

  public function __construct(private readonly ContentInheritService $contentInheritService) {
    parent::__construct();
  }

  /**
   * @command sites-migrator:content-inherit
   * @aliases smci
   */
  public function inheritContent(?string $groupId = NULL): void {
    $this->contentInheritService->inheritContent($groupId, $this->output());
    $this->io()->success('Inherited all content into sites.');
  }

}
