<?php

declare(strict_types=1);

namespace Drupal\sites_migrator\Menu;

/**
 * Interface for the menu configuration migrator.
 *
 * Provides methods to migrate menu type configurations from standard menus to
 * group content menus.
 */
interface MenuConfigMigratorInterface {

  /**
   * Migrates a menu type configuration to a group content menu type.
   *
   * This method duplicates the original menu type and creates a new group content
   * menu type with the same configuration. It also copies field configurations
   * from the original menu type to the new one.
   *
   * @param string $menuMachineName
   *   The machine name of the menu type to migrate.
   */
  public function migrateMenuTypeConfig(string $menuMachineName): void;

}
