<?php

declare(strict_types=1);

namespace Drupal\sites_migrator\Plugin\migrate\source;

use Drupal\migrate\Row;
use Drupal\migrate_drupal_d8\Plugin\migrate\source\d8\ContentEntity;

/**
 * Source plugin for users.
 *
 * @MigrateSource(
 *   id = "user_d8_entity"
 * )
 */
class User extends ContentEntity {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $query = parent::query();

    $existing_usernames = \Drupal::database()
      ->select('users_field_data', 'u')
      ->fields('u', ['name'])
      ->execute()
      ->fetchCol();

    // Skip the already existing user by checking for the username
    if (!empty($existing_usernames)) {
      $query->condition('d.name', $existing_usernames, 'NOT IN');
    }

    // Skip the anonymous user
    $query->condition('d.uid', 0, '<>');

    return $query;
  }

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row) {
    return parent::prepareRow($row);
  }

}