<?php

declare(strict_types=1);

namespace Drupal\sites_migrator\Plugin\migrate\source;

use Drupal\migrate_drupal_d8\Plugin\migrate\source\d8\ContentEntity;
use Drupal\migrate\MigrateException;
use Drupal\migrate\Row;

/**
 * Source plugin for nodes with user email from the original author uid.
 *
 * @MigrateSource(
 *   id = "prepare_content_with_former_author"
 * )
 */
class PrepareContentWithFormerAuthor extends ContentEntity {

  /**
   * {@inheritdoc}
   */
  public function query() {
    $query = parent::query();

    if (
      is_array($query->getTables()) &&
      isset($query->getTables()['d']) &&
      $query->getTables()['d']['table'] === 'node_field_data'
    ) {
      // Fix the expected type
      $query->condition('d.type', $this->configuration['type']);
    }

    return $query;
  }

  /**
   * {@inheritdoc}
   */
  public function prepareRow(Row $row) {
    $uid = $row->getSourceProperty('uid');

    if ($uid) {
      // Load the user email from the source database user table.
      $connection = $this->getDatabase();
      $query = $connection->select('users_field_data', 'u')
        ->fields('u', ['mail'])
        ->condition('u.uid', $uid)
        ->range(0, 1);
      $email = $query->execute()->fetchField();
      if (!$email) {
        throw new MigrateException("Could not find email for uid $uid in source users_field_data table.");
      }
      // Add the email to the source data row.
      $row->setSourceProperty('author_email', $email);
    }
    return parent::prepareRow($row);
  }

}
