<?php

declare(strict_types=1);

namespace Drupal\sites_migrator\Commands;

use Drupal\sites_migrator\DomainModuleService;
use Drush\Commands\DrushCommands;

/**
 * A Drush command class for content inheritance to sites. Especially for
 * existing Drupal sites, which receive a new sites group module setup.
 */
final class DomainModuleCommands extends DrushCommands {

  /**
   * Constructs a new DomainModuleCommands object.
   *
   * @param \Drupal\sites_migrator\DomainModuleService $domainModuleService
   *   The domain module service.
   */
  public function __construct(
    private readonly DomainModuleService $domainModuleService,
  ) {
    parent::__construct();
  }

  /**
   * @command sites-migrator:content-inherit-domain-module
   * @aliases smcidm
   */
  public function inheritContentFromDomainModule(): void {
    $this->domainModuleService->inheritDomainContent($this->output());
    $this->io()->success('Processed content inheritance from the Domain module.');
  }

}
