<?php

declare(strict_types=1);

namespace Drupal\sites_migrator\Menu;

use Drupal\Core\Menu\MenuLinkTreeElement;
use Drupal\menu_item_extras\Entity\MenuItemExtrasMenuLinkContent;
use Drupal\menu_link_content\Plugin\Menu\MenuLinkContent;

/**
 * Interface for MenuService.
 */
interface MenuServiceInterface {

  /**
   * Creates a menu link content entity.
   *
   * @param string $bundle
   *   The bundle of the menu link content.
   * @param int $groupMenuId
   *   The ID of the group menu.
   * @param \Drupal\Core\Menu\MenuLinkTreeElement $menuLinkTreeElement
   *   The menu link tree element.
   * @param \Drupal\menu_item_extras\Entity\MenuItemExtrasMenuLinkContent|null $parent
   *   Optional parent menu link content.
   *
   * @return void
   */
  public function createMenuLinkContent(
    string $bundle,
    int $groupMenuId,
    MenuLinkTreeElement $menuLinkTreeElement,
    ?MenuItemExtrasMenuLinkContent $parent = NULL,
  ): void;

  /**
   * Counts the number of menu items in a menu tree.
   *
   * @param string $sourceMenuName
   *   The name of the source menu.
   *
   * @return int
   *   The total count of menu items.
   */
  public function countMenuItems(string $sourceMenuName): int;

  /**
   * Recursively counts the number of items in a subtree.
   *
   * @param array $subtree
   *   The subtree to count.
   *
   * @return int
   *   The total count of items in the subtree.
   */
  public function countSubtree(array $subtree): int;

  /**
   * Generates a URI from a menu link.
   *
   * @param \Drupal\menu_link_content\Plugin\Menu\MenuLinkContent $menuLink
   *   The menu link content.
   *
   * @return array
   *   The generated URI.
   */
  public function generateUriFromRoute(MenuLinkContent $menuLink): array;

}
