<?php

declare(strict_types=1);

namespace Drupal\Tests\dhb_api_fetcher\ExistingSite;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\group_content_menu\Entity\GroupContentMenu;
use Drupal\group_content_menu\Entity\GroupContentMenuType;
use Drupal\group_content_menu_bundles\Entity\GroupContentMenuItemExtrasMenuLinkContent;
use weitzman\DrupalTestTraits\ExistingSiteBase;

/**
 * @group ExistingSiteBase
 * Note: the mie_demo_base must be installed.
 */
class MenuBundleMigrationTest extends ExistingSiteBase {

  private const TEST_SOURCE_MENU = 'mie-demo-base-menu';

  private const GROUP_MENU_BUNDLE = 'basic_menu';

  protected function setUp(): void {
    parent::setUp();

    $groupContentMenuTypeStorage = $this->container->get('entity_type.manager')->getStorage('group_content_menu_type');
    $groupContentMenuType = $groupContentMenuTypeStorage->load('group_' . self::TEST_SOURCE_MENU);
    if ($groupContentMenuType instanceof GroupContentMenuType) {
      $groupContentMenuType->delete();
    }
  }

  public function testMenuBundleMigration(): void {
    $entityTypeManager = \Drupal::entityTypeManager();
    /**
     * @var \Drupal\sites_migrator\MenuConfigMigrator $menuConfigMigrator
     */
    $menuConfigMigrator = \Drupal::service('sites_migrator.menu_config_migrator');

    $menuConfigMigrator->migrateMenuTypeConfig(self::TEST_SOURCE_MENU);

    $groupContentMenuTypeStorage = $this->container->get('entity_type.manager')->getStorage('group_content_menu_type');
    $groupContentMenuType = $groupContentMenuTypeStorage->load('group_' . self::TEST_SOURCE_MENU);
    $this->assertInstanceOf(GroupContentMenuType::class, $groupContentMenuType);

    $countBeforeCreateGroupContentMenu = $this->countMenuItemsBeforeMigration($entityTypeManager);

    /**
     * @var \Drupal\sites_migrator\MenuContentMigrator $menuContentMigrator
     */
    $menuContentMigrator = \Drupal::service('sites_migrator.menu_content_migrator');

    $menuContentMigrator->migrateMenuItems(self::TEST_SOURCE_MENU, 2, self::GROUP_MENU_BUNDLE, 'Some menu label');

    $this->assertMenuItemsCreation($entityTypeManager, $countBeforeCreateGroupContentMenu);
  }

  private function assertMenuItemsCreation(EntityTypeManagerInterface $entityTypeManager, ?int $countBeforeCreateGroupContentMenu): void {
    $groupContentMenuItemIds = $entityTypeManager
      ->getStorage('group_content_menu')
      ->getQuery()
      ->accessCheck(FALSE)
      ->condition('bundle', self::GROUP_MENU_BUNDLE)
      ->execute();

    $this->assertEquals($countBeforeCreateGroupContentMenu + 1, count($groupContentMenuItemIds));

    $groupContentMenus = GroupContentMenu::loadMultiple($groupContentMenuItemIds);

    $idRecentlyCreatedGroupContentMenu = (function ($groupContentMenus) {
      $recentlyCreatedMenu = array_pop($groupContentMenus);
      return $recentlyCreatedMenu->id();
    })($groupContentMenus);

    $groupContentMenuItemIds = $entityTypeManager
      ->getStorage('menu_link_content')
      ->getQuery()
      ->accessCheck(FALSE)
      ->condition('menu_name', 'group_menu_link_content-' . $idRecentlyCreatedGroupContentMenu)
      ->execute();

    $this->assertGreaterThan(2, count($groupContentMenuItemIds));
  }

  private function countMenuItemsBeforeMigration(EntityTypeManagerInterface $entityTypeManager): ?int {
    $menuItems = GroupContentMenuItemExtrasMenuLinkContent::loadMultiple(
      [
        'menu_name' => 'group_' . self::TEST_SOURCE_MENU,
      ]
    );
    $this->assertEmpty($menuItems);
    $groupContentMenuItemIds = $entityTypeManager
      ->getStorage('group_content_menu')
      ->getQuery()
      ->accessCheck(FALSE)
      ->condition('bundle', self::GROUP_MENU_BUNDLE)
      ->execute();
    $countBeforeCreateGroupContentMenu = count($groupContentMenuItemIds);
    return $countBeforeCreateGroupContentMenu;
  }

}
