<?php

namespace Drupal\skip_logout_confirmation\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Symfony\Component\Routing\RouteCollection;

class RouteSubscriber extends RouteSubscriberBase {

  protected function alterRoutes(RouteCollection $collection) {
    // Modifie la route de déconnexion pour supprimer le formulaire de confirmation
    if ($route = $collection->get('user.logout')) {
      $route->setDefaults([
        '_controller' => '\Drupal\user\Controller\UserAuthenticationController::logout',
      ]);
    }
  }

}