# SkynetAccessiblity Scanner

## Overview

The SkynetAccessibility Scanner Application is a powerful Accessibility,
Testing Tool and Accessibility Scanning Software that enables organizations,
businesses, government entities, and individuals to proactively scan, monitor,
and remediate accessibility compliance issues. It functions as both an,
Accessibility Checker and Accessibility Compliance Testing Software,
ensuring websites and applications meet global and regional accessibility standards.

It supports compliance with WCAG 2.0, 2.1, 2.2, ADA, Section 508,
European EN 301 549, UK Equality Act, Australian DDA, Canada ACA,
and European countries accessibility standards (such as Germany BITV 2.0,
\France RGAA, Spain UNE 139803, and Italy Stanca Act).
With user-friendly issue highlighting and remediation recommendations,
even non-technical users can resolve accessibility challenges effectively.

This tool is designed for:

Businesses of all sizes
Enterprises
Government entities
Website owners
E-commerce platforms
Development and maintenance agencies
[Start your 10-Day Free Trial today!](https://skynetaccessibilityscan.com/trial-subscription)

### Why SkynetAccessibility Scanner?

In today’s digital world, Accessibility Testing isn’t a one-time task.
Evolving standards and regulations require continuous monitoring and compliance.
This solution empowers organizations to detect, track,
and remediate accessibility violations across websites,
web applications, and documents using advanced Accessibility Scanning Software.

With proactive monitoring, you can ensure that your digital properties,
remain inclusive and accessible, while minimizing compliance risks.

## Key Features

1. Accessibility Testing – Automated scanning and issue detection with actionable guidance.
2. Accessibility Checker – Highlights issues and suggests fixes for developers and content editors.
3. 10-Days Free Trial – Get started risk-free. Subscriptions auto-convert after trial, with pay-later flexibility.
4. Flexible Subscription – Cancel anytime with no hidden fees.
5. Sitemap-Based Monitoring – Automatically scans website pages based on sitemap.
6. Automated Comprehensive Website Scanning – Detect WCAG, ADA, Section 508, EN 301 549, and other compliance violations within 24 hours of setup.
7. Scheduled Monitoring – Automate scans weekly, monthly, or quarterly.
8. Auto-Generated Scan Reports – Detailed reports with severity levels, recommendations, and compliance tracking.
9. Multi-Language Support – Scanning and monitoring available in 40+ languages.
10. Integration with All in One Accessibility® Dashboard – Centralized insights and controls.
11. Optional Add-Ons – Enhance compliance with custom add-ons.
12. Accessibility Compliance Testing Software - features for enterprise workflows and audit trails.
13. Accessibility Scanning Monitoring Application - supports API-based integrations for automation and reporting.

## Compliance Standards Supported

1. WCAG 2.0, 2.1, 2.2
2. ADA
3. Section 508
4. EN 301 549 (EU)
5. UK Equality Act
6. Australian DDA
7. Canada ACA

European Countries Accessibility Standards
Our SkynetAccessibility Scanner Application aligns with European country-level accessibility requirements, including (but not limited to):

Germany — BITV 2.0 (Barrierefreie Informationstechnik-Verordnung)
France — RGAA (Référentiel Général d’Amélioration de l’Accessibilité)
Spain — UNE 139803 (Spanish accessibility technical standard)
Italy — Stanca Act (Legislative Decree on Accessibility of ICT)
Netherlands — Tijdelijke richtlijn / Nederland accessibility requirements (aligns with EN 301 549)
Sweden — Swedish regulations aligned with EU accessibility directives
Poland, Belgium, Portugal, Ireland, Greece, Czechia — national implementations that map to EN 301 549 / WCAG requirements
Note: EN 301 549 is the EU-level harmonized standard that maps to WCAG and is widely used as the technical reference for accessibility across EU member states. Individual countries may have additional national guidance and implementation specifics — the scanner flags issues against common technical checks and can be mapped to local regulations for reporting.

## How It Works

1. Scan Your Website – Run automated scans to detect accessibility issues with our Accessibility Testing Tool.
2. Review Reports – Access prioritized issue lists with remediation recommendations.
3. Monitor & Maintain – Keep your website accessible with ongoing monitoring using the Accessibility Scanning Monitoring Application.

## Getting Started

1. Visit [Skynet Technologies Accessibility Monitoring](https://www.skynettechnologies.com/accessibility-scanning-and-monitoring).
2. Request a demo or sign up for a free [trial](https://skynetaccessibilityscan.com/trial-subscription).
3. Configure domains and scan settings.
4. Start monitoring accessibility compliance and download reports.

## Who Can Benefit?

1. Website Owners & Businesses
2. Developers & Web Agencies
3. Digital Marketing & SEO Professionals
4. Government & Public Sector Organizations
5. Legal & Compliance Teams
6. Advocacy & Accessibility-Focused Organizations
7. E-commerce & SaaS Platforms

## Installation

### Prerequisites

- Drupal 8.X
- Supported Minimum/Maximum Version of Platform

### Steps

You can install this module with two ways.

#### Via Composer

    1.  Navigate to your Drupal root directory.
    2.  Run the following command to install the module:
        ``` bash
        composer require composer require 'drupal/skynetaccessibility_scanner'
        ```
    3. After the module is installed, enable it using
   Drush or through the Drupal admin interface.

#### Manual Installation

    1. Download the module from [Drupal.org](https://www.drupal.org/project/skynetaccessibility_scanner).
    2. Extract the downloaded file and place it in 
  the `modules/contrib` directory of your Drupal installation.
    3. Enable the module using Drush or through the Drupal admin interface.

## CORS Policy Configuration

To avoid CORS policy issues, ensure the following URLs are allowed in your website. These URLs should be added to your CORS configuration or trusted domains list.

|               Domain                  |               Description                 |         Usage            |
|---------------------------------------|-------------------------------------------|--------------------------|
| `https://skynetaccessibilityscan.com` | Skynet Accessibility Scan (Global Domain) | API access and resources |

## Configuration

    1. Navigate to the configuration page for the module:
    - `admin/config/development/skynetaccessibility-scanner`

## Send Us an Email

Alternatively, you can send an email to our support team:
[hello@skynettechnologies.com](mailto:hello@skynettechnologies.com)

## Credits

This addon is developed and maintained by [Skynet Technologies USA LLC](https://www.skynettechnologies.com)

## Current Maintainers

- [Skynet Technologies USA LLC](https://www.drupal.org/skynet-technologies-usa-llc)
