(function ($, Drupal, once) {
  "use strict";

  Drupal.behaviors.scanningMonitoring = {
    attach: function (context, settings) {
      // Handle image loading errors
      $(once("image-fallback", ".icon-circle img", context)).on(
        "error",
        function () {
          $(this).hide();
          // You could add a fallback icon using CSS or replace with SVG
          console.log("Image failed to load: ", $(this).attr("src"));
        }
      );

      // Handle billing toggle
      $(once("billing-toggle", "#billing-toggle", context)).change(function () {
        var isYearly = $(this).is(":checked");

        // Update labels
        $("#monthly-label").toggleClass("active", !isYearly);
        $("#annual-label").toggleClass("active", isYearly);

        // Toggle price display
        $(".monthly-price").toggleClass("hidden", isYearly);
        $(".yearly-price").toggleClass("hidden", !isYearly);

        // Highlight or dim the 20% OFF label using opacity
        var $discountLabel = $("#discount-label"); // <-- your 20% OFF element
        if ($discountLabel.length) {
          // Smooth transition (only set once)
          $discountLabel.css({
            transition: "opacity 0.3s ease-in-out",
          });

          if (isYearly) {
            $discountLabel.css({
              opacity: 1, // fully visible when yearly is selected
            });
          } else {
            $discountLabel.css({
              opacity: 0.4, // faded (gray look) when monthly is selected
            });
          }
        }

        // Update URL parameter if needed
        var url = new URL(window.location.href);
        url.searchParams.set("interval", isYearly ? "Y" : "M");
        window.history.replaceState({}, "", url);
      });

      // Initialize billing toggle based on URL parameter
      var urlParams = new URLSearchParams(window.location.search);
      var interval = urlParams.get("interval");
      if (interval === "Y") {
        $("#billing-toggle").prop("checked", TRUE).trigger("change");
      }

      // Report date functionality
      $(once("report-date", "#report-date", context)).change(function () {
        // Add functionality to load different report data
        console.log("Report date changed to:", $(this).val());
      });

      // View all violations button
      $(once("view-violations", ".view-btn", context)).click(function () {
        // Add functionality to show all violations
        console.log("View all violations clicked");
      });

      // Handle plan upgrade/cancel actions
      $(once("plan-actions", ".upgrade-btn", context)).click(function (e) {
        var isCurrentPlan = $(this).hasClass("current-plan");
        if (isCurrentPlan) {
          var confirmCancel = confirm(
            "Are you sure you want to cancel your subscription?"
          );
          if (!confirmCancel) {
            e.preventDefault();
          }
        }
      });
    },
  };
})(jQuery, Drupal, once);
